/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.taskman.sim;

import filenet.vw.api.VWException;
import filenet.vw.apps.taskman.VWTaskActionCommand;
import filenet.vw.apps.taskman.VWTaskNumericProperty;
import filenet.vw.apps.taskman.VWTaskPropertyChangedEvent;
import filenet.vw.apps.taskman.VWTaskPropertyPanel;
import filenet.vw.apps.taskman.VWTaskTabPanel;
import filenet.vw.apps.taskman.VWTaskTabbedPane;
import filenet.vw.apps.taskman.VWTaskUtil;
import filenet.vw.apps.taskman.sim.VWSimConvertTwo;
import filenet.vw.apps.taskman.sim.VWSimEngineNode;
import filenet.vw.apps.taskman.sim.resources.VWResource;
import filenet.vw.apps.taskman.toolkit.VWTaskJComboBox;
import filenet.vw.base.VWAuthItem;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.FileOutputStream;
import java.util.Properties;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;

public class VWSimEnginePropertyPanel
extends VWTaskPropertyPanel {
    VWSimEngineNode m_node = null;
    VWTaskTabbedPane m_tabbedPane = null;
    JLabel m_iconLabel = null;
    JTextField m_tempDir = null;
    VWTaskNumericProperty m_registryPort = null;
    VWTaskNumericProperty m_publisherTimeout = null;
    VWTaskNumericProperty m_dataTimeOut = null;
    VWTaskNumericProperty m_maxJobs = null;
    VWTaskNumericProperty m_javaMinMem = null;
    VWTaskNumericProperty m_javaMaxMem = null;
    JComboBox m_processCubes = null;
    JTextField m_localHost = null;
    VWTaskNumericProperty m_returnPort = null;
    VWTaskNumericProperty m_paProdPort = null;
    JTextField m_paProdHost = null;
    JTextField m_paProdDbUser = null;
    JPasswordField m_paProdDbPassword = null;
    VWTaskNumericProperty m_paProdDbPort = null;
    JTextField m_paProdDbHost = null;
    JTextField m_paProdDbName = null;
    VWTaskNumericProperty m_paSimPort = null;
    JTextField m_paSimHost = null;
    JTextField m_paSimDbUser = null;
    JPasswordField m_paSimDbPassword = null;
    VWTaskNumericProperty m_paSimDbPort = null;
    JTextField m_paSimDbHost = null;
    JTextField m_paSimDbName = null;
    JTextField m_simDBDriverName = null;
    JTextField m_prodDBDriverName = null;
    JTextArea m_simDBDriverClasspath = null;
    JTextArea m_prodDBDriverClasspath = null;
    private static final boolean REQUIRED = true;
    private static final boolean NOT_REQUIRED = false;
    protected static final String S_PROPERTIES_SERVICE_LOCALHOST = "simulator.service.localhost";

    public VWSimEnginePropertyPanel(VWSimEngineNode simEngineNode) throws Exception {
        this.setDoubleBuffered(true);
        this.setLayout(new BorderLayout());
        this.m_node = simEngineNode;
        this.addTabbedPane();
        this.refresh();
        this.m_tabbedPane.addVWTaskPropertyChangedListener(this);
    }

    public void refresh() {
        try {
            this.resetProperties();
            boolean stopped = !this.m_node.isStarted();
            this.m_iconLabel.setIcon(this.m_node.getIcon32());
            this.m_registryPort.setEditable(stopped);
            this.m_javaMinMem.setEditable(stopped);
            this.m_javaMaxMem.setEditable(stopped);
            this.m_returnPort.setEditable(stopped);
            this.m_localHost.setEditable(stopped);
        }
        catch (Exception e) {
            this.m_node.displayError(e);
        }
    }

    private void addTabbedPane() {
        this.m_tabbedPane = new VWTaskTabbedPane();
        this.m_tabbedPane.addTab(filenet.vw.apps.taskman.resources.VWResource.General, this.getGeneralPanel(), false);
        this.m_tabbedPane.addTab(VWResource.ProcessAnalyzer, this.getProcessAnalyzerPanelEx());
        this.m_tabbedPane.addTab(filenet.vw.apps.taskman.resources.VWResource.Advanced, this.getAdvancedPanel());
        this.add((Component)this.m_tabbedPane, "Center");
    }

    private VWTaskTabPanel getGeneralPanel() {
        VWTaskTabPanel panel = new VWTaskTabPanel();
        panel.setHelpPage(VWHelp.Help_Process_TaskManager + "simulator_general.htm");
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 0;
        c.anchor = 23;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(4, 10, 0, 0);
        c.gridx = 0;
        c.gridy = 0;
        this.m_iconLabel = new JLabel(this.m_node.getIcon32(), 2);
        panel.add((Component)this.m_iconLabel, c);
        c.fill = 2;
        c.weightx = 1.0;
        c.gridy = 0;
        c.gridx = 1;
        c.insets = new Insets(15, 10, 0, 0);
        c.gridwidth = 0;
        panel.add((Component)new JLabel(VWResource.ProcessOptimizer), c);
        c.gridy = 1;
        c.gridx = 0;
        c.fill = 1;
        c.gridwidth = 0;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(20, 0, 0, 0);
        panel.add((Component)this.getGeneralPropertiesPanel(), c);
        c.gridy = 2;
        c.gridx = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.insets = new Insets(0, 0, 0, 0);
        panel.add(Box.createHorizontalStrut(0), c);
        return panel;
    }

    private VWTaskTabPanel getGeneralPropertiesPanel() {
        VWTaskTabPanel panel = new VWTaskTabPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbConst = new GridBagConstraints();
        this.m_maxJobs = new VWTaskNumericProperty("");
        this.m_maxJobs.addFocusListener(this);
        this.m_maxJobs.setName(VWResource.MaxJobs);
        panel.add((Component)new JLabel(this.m_maxJobs.getName() + ":"), LABEL_CONSTRAINTS);
        panel.add((JTextComponent)this.m_maxJobs, (Object)FIELD_CONSTRAINTS, true);
        this.m_tempDir = new JTextField("");
        this.m_tempDir.addFocusListener(this);
        this.m_tempDir.setName(VWResource.TempDirectory);
        panel.add((Component)new JLabel(this.m_tempDir.getName() + ":"), LABEL_CONSTRAINTS);
        panel.add((JTextComponent)this.m_tempDir, (Object)FIELD_CONSTRAINTS, false);
        this.m_javaMinMem = new VWTaskNumericProperty("");
        this.m_javaMinMem.addFocusListener(this);
        this.m_javaMinMem.setName(filenet.vw.apps.taskman.resources.VWResource.JavaMinMemory);
        panel.add((Component)new JLabel(this.m_javaMinMem.getName() + ":"), LABEL_CONSTRAINTS);
        panel.add((JTextComponent)this.m_javaMinMem, (Object)FIELD_CONSTRAINTS, false);
        this.m_javaMaxMem = new VWTaskNumericProperty("");
        this.m_javaMaxMem.addFocusListener(this);
        this.m_javaMaxMem.setName(filenet.vw.apps.taskman.resources.VWResource.JavaMaxMemory);
        panel.add((Component)new JLabel(this.m_javaMaxMem.getName() + ":"), LABEL_CONSTRAINTS);
        panel.add((JTextComponent)this.m_javaMaxMem, (Object)FIELD_CONSTRAINTS, false);
        this.m_registryPort = new VWTaskNumericProperty("");
        this.m_registryPort.addFocusListener(this);
        this.m_registryPort.setName(filenet.vw.apps.taskman.resources.VWResource.RegistryPort);
        panel.add((Component)new JLabel(this.m_registryPort.getName() + ":"), LABEL_CONSTRAINTS);
        panel.add((JTextComponent)this.m_registryPort, (Object)FIELD_CONSTRAINTS, true);
        Object[] pcOptions = new String[]{filenet.vw.apps.taskman.resources.VWResource.On, filenet.vw.apps.taskman.resources.VWResource.Off};
        this.m_processCubes = new VWTaskJComboBox(pcOptions);
        this.m_processCubes.setName(VWResource.ProcessCubes);
        panel.add((Component)new JLabel(this.m_processCubes.getName() + ":"), LABEL_CONSTRAINTS);
        panel.add((Component)this.m_processCubes, FIELD_CONSTRAINTS);
        return panel;
    }

    private VWTaskTabPanel getAdvancedPanel() {
        VWTaskTabPanel panel = new VWTaskTabPanel();
        panel.setHelpPage(VWHelp.Help_Process_TaskManager + "simulator_advanced.htm");
        panel.setLayout(new GridBagLayout());
        this.m_publisherTimeout = new VWTaskNumericProperty("");
        this.m_publisherTimeout.addFocusListener(this);
        this.m_publisherTimeout.setName(VWResource.PublisherTimeout);
        panel.add((Component)new JLabel(this.m_publisherTimeout.getName() + ":"), LABEL_CONSTRAINTS);
        panel.add((JTextComponent)this.m_publisherTimeout, (Object)FIELD_CONSTRAINTS, true);
        this.m_dataTimeOut = new VWTaskNumericProperty("");
        this.m_dataTimeOut.addFocusListener(this);
        this.m_dataTimeOut.setName(VWResource.DataTimeOut);
        panel.add((Component)new JLabel(this.m_dataTimeOut.getName() + ":"), LABEL_CONSTRAINTS);
        panel.add((JTextComponent)this.m_dataTimeOut, (Object)FIELD_CONSTRAINTS, true);
        this.m_returnPort = new VWTaskNumericProperty("");
        this.m_returnPort.addFocusListener(this);
        this.m_returnPort.setName(VWResource.ReturnPort);
        panel.add((Component)new JLabel(this.m_returnPort.getName() + ":"), LABEL_CONSTRAINTS);
        panel.add((JTextComponent)this.m_returnPort, (Object)FIELD_CONSTRAINTS, false);
        this.m_localHost = new JTextField("");
        this.m_localHost.addFocusListener(this);
        this.m_localHost.setName(VWResource.LocalHost);
        panel.add((Component)new JLabel(this.m_localHost.getName() + ":"), LABEL_CONSTRAINTS);
        panel.add((JTextComponent)this.m_localHost, (Object)FIELD_CONSTRAINTS, false);
        return panel;
    }

    private JPanel getProcessAnalyzerPanelEx() {
        VWTaskTabPanel panel = new VWTaskTabPanel(new GridBagLayout());
        panel.setHelpPage(VWHelp.Help_Process_TaskManager + "simulator_pa.htm");
        VWToolbarBorder borderPanel = new VWToolbarBorder(VWResource.ProcessAnalyzerConnectionSettings, 0, panel);
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 23;
        c.fill = 1;
        c.gridwidth = 1;
        VWTaskTabbedPane tabPane = new VWTaskTabbedPane();
        this.m_paProdHost = new JTextField("");
        this.m_paProdHost.addFocusListener(this);
        this.m_paProdPort = new VWTaskNumericProperty("");
        this.m_paProdPort.addFocusListener(this);
        this.m_paProdPort.setPreferredSize(new Dimension(60, (int)this.m_paProdPort.getPreferredSize().getHeight()));
        this.m_paProdDbName = new JTextField("");
        this.m_paProdDbName.addFocusListener(this);
        this.m_paProdDbHost = new JTextField("");
        this.m_paProdDbHost.addFocusListener(this);
        this.m_paProdDbPort = new VWTaskNumericProperty("");
        this.m_paProdDbPort.addFocusListener(this);
        this.m_paProdDbPort.setPreferredSize(new Dimension(60, (int)this.m_paProdPort.getPreferredSize().getHeight()));
        this.m_paProdDbUser = new JTextField("");
        this.m_paProdDbUser.addFocusListener(this);
        this.m_paProdDbPassword = new JPasswordField("");
        this.m_paProdDbPassword.addFocusListener(this);
        this.m_prodDBDriverName = new JTextField("");
        this.m_prodDBDriverName.addFocusListener(this);
        this.m_prodDBDriverName.setName(VWResource.JDBCDriverName);
        this.m_prodDBDriverClasspath = this.getJDBCDriverClasspathControl();
        this.m_prodDBDriverClasspath.addFocusListener(this);
        this.m_prodDBDriverClasspath.setName(VWResource.JDBCDriverClassPath);
        VWTaskTabPanel productionPanel = this.getPAPanel(VWResource.ProductionProcessAnalyzer, this.m_paProdHost, this.m_paProdPort, this.m_paProdDbHost, this.m_paProdDbPort, this.m_paProdDbName, this.m_paProdDbUser, this.m_paProdDbPassword, this.m_prodDBDriverName, this.m_prodDBDriverClasspath);
        tabPane.addTab(VWResource.Production, productionPanel);
        this.m_paSimHost = new JTextField("");
        this.m_paSimHost.addFocusListener(this);
        this.m_paSimPort = new VWTaskNumericProperty("");
        this.m_paSimPort.addFocusListener(this);
        this.m_paSimPort.setPreferredSize(new Dimension(60, (int)this.m_paProdPort.getPreferredSize().getHeight()));
        this.m_paSimDbHost = new JTextField("");
        this.m_paSimPort.addFocusListener(this);
        this.m_paSimDbName = new JTextField("");
        this.m_paSimDbName.addFocusListener(this);
        this.m_paSimDbPort = new VWTaskNumericProperty("");
        this.m_paSimDbPort.addFocusListener(this);
        this.m_paSimDbPort.setPreferredSize(new Dimension(60, (int)this.m_paProdPort.getPreferredSize().getHeight()));
        this.m_paSimDbUser = new JTextField("");
        this.m_paSimDbUser.addFocusListener(this);
        this.m_paSimDbPassword = new JPasswordField("");
        this.m_paSimDbPassword.addFocusListener(this);
        this.m_simDBDriverName = new JTextField("");
        this.m_simDBDriverName.addFocusListener(this);
        this.m_simDBDriverName.setName(VWResource.JDBCDriverName);
        this.m_simDBDriverClasspath = this.getJDBCDriverClasspathControl();
        this.m_simDBDriverClasspath.setName(VWResource.JDBCDriverClassPath);
        VWTaskTabPanel simulationPanel = this.getPAPanel(VWResource.SimulationProcessAnalyzer, this.m_paSimHost, this.m_paSimPort, this.m_paSimDbHost, this.m_paSimDbPort, this.m_paSimDbName, this.m_paSimDbUser, this.m_paSimDbPassword, this.m_simDBDriverName, this.m_simDBDriverClasspath);
        tabPane.addTab(VWResource.Simulation, simulationPanel, false);
        c.weighty = 1.0;
        c.weightx = 1.0;
        c.gridx = 0;
        ++c.gridy;
        c.insets = new Insets(10, 10, 20, 5);
        panel.add((Component)tabPane, c);
        return borderPanel;
    }

    private JTextArea getJDBCDriverClasspathControl() {
        JTextArea txtArea = new JTextArea();
        VWTaskUtil.updateComponentOrientation(txtArea);
        txtArea.setBorder(new JTextField().getBorder());
        txtArea.setRows(4);
        txtArea.setPreferredSize(new Dimension(50, (int)txtArea.getPreferredSize().getHeight()));
        txtArea.setLineWrap(true);
        txtArea.addFocusListener(this);
        return txtArea;
    }

    private VWTaskTabPanel getPAPanel(String title, JTextField paHost, VWTaskNumericProperty paPort, JTextField dbHost, VWTaskNumericProperty dbPort, JTextField dbName, JTextField dbUser, JTextField dbPassword, JTextField jdbcDriverName, JTextArea jdbcDriverClasspath) {
        VWTaskTabPanel panel = new VWTaskTabPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 23;
        c.insets = new Insets(10, 10, 0, 5);
        c.weighty = 0.0;
        c.weightx = 0.0;
        c.gridwidth = 1;
        c.insets.right = 5;
        panel.add((Component)new JLabel(VWResource.ProcessAnalyzerHost + ":"), c);
        c.weightx = 1.0;
        c.gridwidth = 1;
        c.insets.right = 5;
        panel.add((JTextComponent)paHost, (Object)c, false);
        c.weightx = 0.0;
        c.gridwidth = 1;
        c.insets.right = 5;
        panel.add((Component)new JLabel(VWResource.ProcessAnalyzerPort + ":"), c);
        c.weightx = 0.0;
        c.gridwidth = 0;
        c.insets.right = 5;
        panel.add((JTextComponent)paPort, (Object)c, false);
        c.weightx = 0.0;
        c.gridwidth = 1;
        c.insets.right = 5;
        panel.add((Component)new JLabel(filenet.vw.apps.taskman.resources.VWResource.DatabaseHost + ":"), c);
        c.weightx = 1.0;
        c.gridwidth = 1;
        c.insets.right = 5;
        panel.add((JTextComponent)dbHost, (Object)c, false);
        c.weightx = 0.0;
        c.gridwidth = 1;
        c.insets.right = 5;
        panel.add((Component)new JLabel(filenet.vw.apps.taskman.resources.VWResource.DatabasePort + ":"), c);
        c.weightx = 0.0;
        c.gridwidth = 0;
        c.insets.right = 5;
        panel.add((JTextComponent)dbPort, (Object)c, false);
        c.weightx = 0.0;
        c.gridwidth = 1;
        c.insets.right = 5;
        panel.add((Component)new JLabel(VWResource.DatabaseName + ":"), c);
        c.weightx = 1.0;
        c.gridwidth = 0;
        c.insets.right = 5;
        panel.add((JTextComponent)dbName, (Object)c, false);
        c.weightx = 0.0;
        c.gridwidth = 1;
        c.insets.right = 5;
        panel.add((Component)new JLabel(VWResource.DBLoginUserName + ":"), c);
        c.weightx = 1.0;
        c.gridwidth = 0;
        c.insets.right = 5;
        panel.add((JTextComponent)dbUser, (Object)c, false);
        c.weightx = 0.0;
        c.gridwidth = 1;
        c.insets.right = 5;
        panel.add((Component)new JLabel(VWResource.DBLoginPassword + ":"), c);
        c.weightx = 1.0;
        c.gridwidth = 0;
        c.insets.right = 5;
        panel.add((JTextComponent)dbPassword, (Object)c, false);
        c.weightx = 0.0;
        c.gridwidth = 1;
        c.insets.right = 5;
        c.weightx = 1.0;
        c.gridwidth = 0;
        c.insets.right = 5;
        panel.add((JTextComponent)jdbcDriverName, (Object)c, true);
        jdbcDriverName.setVisible(false);
        c.weightx = 0.0;
        c.gridwidth = 1;
        c.insets.right = 5;
        c.weightx = 1.0;
        c.gridwidth = 0;
        c.insets.right = 5;
        panel.add((Component)jdbcDriverClasspath, c);
        jdbcDriverClasspath.setVisible(false);
        c.weightx = 0.0;
        c.weighty = 1.0;
        panel.add(Box.createHorizontalStrut(0), c);
        return panel;
    }

    public void actionPerformed(ActionEvent event) {
        String actionCMD = event.getActionCommand();
        Object aObj = event.getSource();
        try {
            if (VWStringUtils.compare(actionCMD, VWTaskActionCommand.APPLY) == 0 || VWStringUtils.compare(actionCMD, VWTaskActionCommand.OK) == 0) {
                if (this.validateProperties()) {
                    this.applyProperties();
                }
            } else if (VWStringUtils.compare(actionCMD, VWTaskActionCommand.RESET) == 0 || VWStringUtils.compare(actionCMD, VWTaskActionCommand.CANCEL) == 0) {
                this.resetProperties();
            } else if (VWStringUtils.compare(actionCMD, VWTaskActionCommand.HELP) == 0) {
                this.m_tabbedPane.displayHelp();
            }
        }
        catch (Exception ex) {
            this.m_node.displayError(ex);
        }
    }

    public void applyProperties() throws Exception {
        VWSimConvertTwo convertTwo = new VWSimConvertTwo();
        Properties props = (Properties)this.m_node.getPSProperties().clone();
        props.setProperty("simulator.serviceport", this.m_registryPort.getText().trim());
        props.setProperty("simulator.maxjobs", this.m_maxJobs.getText().trim());
        props.setProperty("simulator.uncprefix", this.m_tempDir.getText().trim());
        props.setProperty("simulator.JavaMinMem", this.m_javaMinMem.getText().trim());
        props.setProperty("simulator.JavaMaxMem", this.m_javaMaxMem.getText().trim());
        if (VWStringUtils.compare((String)this.m_processCubes.getSelectedItem(), filenet.vw.apps.taskman.resources.VWResource.On) == 0) {
            props.setProperty("simulator.DoProcessCubes", "true");
        } else {
            props.setProperty("simulator.DoProcessCubes", "false");
        }
        props.setProperty("simulator.prodpa.jdbcdriver", this.m_prodDBDriverName.getText().trim());
        props.setProperty("simulator.prodpa.jdbcclasspath", this.m_prodDBDriverClasspath.getText().trim());
        props.setProperty("simulator.production.aeserver", this.m_paProdHost.getText().trim());
        props.setProperty("simulator.production.aeport", this.m_paProdPort.getText().trim());
        props.setProperty("simulator.production.dbserver", this.m_paProdDbHost.getText().trim());
        props.setProperty("simulator.production.dbName", this.m_paProdDbName.getText().trim());
        props.setProperty("simulator.production.sqlservertcpport", this.m_paProdDbPort.getText().trim());
        props.setProperty("simulator.production.dbtoken", convertTwo.getEString(this.m_paProdDbUser.getText().trim(), new String(this.m_paProdDbPassword.getPassword())));
        props.setProperty("simulator.simpa.jdbcdriver", this.m_simDBDriverName.getText().trim());
        props.setProperty("simulator.simpa.jdbcclasspath", this.m_simDBDriverClasspath.getText().trim());
        props.setProperty("simulator.simulator.aeserver", this.m_paSimHost.getText().trim());
        props.setProperty("simulator.simulator.aeport", this.m_paSimPort.getText().trim());
        props.setProperty("simulator.simulator.dbserver", this.m_paSimDbHost.getText().trim());
        props.setProperty("simulator.simulator.dbName", this.m_paSimDbName.getText().trim());
        props.setProperty("simulator.simulator.sqlservertcpport", this.m_paSimDbPort.getText().trim());
        props.setProperty("simulator.simulator.dbtoken", convertTwo.getEString(this.m_paSimDbUser.getText().trim(), new String(this.m_paSimDbPassword.getPassword())));
        props.setProperty("simulator.PublisherTimeout", this.m_publisherTimeout.getText().trim());
        props.setProperty("simulator.datatimeout", this.m_dataTimeOut.getText().trim());
        props.setProperty("simulator.service.returnport", this.m_returnPort.getText().trim());
        props.setProperty(S_PROPERTIES_SERVICE_LOCALHOST, this.m_localHost.getText().trim());
        FileOutputStream propFile = null;
        try {
            propFile = new FileOutputStream(this.m_node.getPSPropertiesPath(), false);
            props.store(propFile, null);
            this.m_node.setPSProperties(props);
        }
        catch (Exception e) {
            throw new VWException("vw.apps.taskman.sim.VWSimEnginePropertyPanel.ErrorUpdatingPropsFile", "Error updating {0} properties file: {1}", VWResource.ProcessOptimizer, e.getLocalizedMessage());
        }
        finally {
            if (propFile != null) {
                try {
                    propFile.close();
                    propFile = null;
                }
                catch (Exception e) {}
            }
        }
        this.taskPropertyChanged(new VWTaskPropertyChangedEvent((Object)this, 1));
    }

    public void resetProperties() throws Exception {
        VWSimConvertTwo convertTwo = new VWSimConvertTwo();
        Properties props = this.m_node.getPSProperties();
        this.m_registryPort.setText(props.getProperty("simulator.serviceport", ""));
        this.m_maxJobs.setText(props.getProperty("simulator.maxjobs", ""));
        this.m_tempDir.setText(props.getProperty("simulator.uncprefix", ""));
        this.m_javaMinMem.setText(props.getProperty("simulator.JavaMinMem", ""));
        this.m_javaMaxMem.setText(props.getProperty("simulator.JavaMaxMem", ""));
        if (new Boolean(props.getProperty("simulator.DoProcessCubes", "")).booleanValue()) {
            this.m_processCubes.setSelectedItem(filenet.vw.apps.taskman.resources.VWResource.On);
        } else {
            this.m_processCubes.setSelectedItem(filenet.vw.apps.taskman.resources.VWResource.Off);
        }
        this.m_prodDBDriverName.setText(props.getProperty("simulator.prodpa.jdbcdriver", ""));
        this.m_prodDBDriverClasspath.setText(props.getProperty("simulator.prodpa.jdbcclasspath", ""));
        this.m_paProdHost.setText(props.getProperty("simulator.production.aeserver", ""));
        this.m_paProdPort.setText(props.getProperty("simulator.production.aeport", ""));
        this.m_paProdDbHost.setText(props.getProperty("simulator.production.dbserver", this.m_paProdHost.getText()));
        this.m_paProdDbName.setText(props.getProperty("simulator.production.dbName", "VMAEDM"));
        this.m_paProdDbPort.setText(props.getProperty("simulator.production.sqlservertcpport", "1433"));
        VWAuthItem authItem = convertTwo.getDString(props.getProperty("simulator.production.dbtoken", ""));
        this.m_paProdDbUser.setText(authItem != null ? authItem.getName() : "");
        this.m_paProdDbPassword.setText(authItem != null ? authItem.getPassword() : "");
        this.m_simDBDriverName.setText(props.getProperty("simulator.simpa.jdbcdriver", ""));
        this.m_simDBDriverClasspath.setText(props.getProperty("simulator.simpa.jdbcclasspath", ""));
        this.m_paSimHost.setText(props.getProperty("simulator.simulator.aeserver", ""));
        this.m_paSimPort.setText(props.getProperty("simulator.simulator.aeport", ""));
        this.m_paSimDbHost.setText(props.getProperty("simulator.simulator.dbserver", this.m_paSimHost.getText()));
        this.m_paSimDbName.setText(props.getProperty("simulator.simulator.dbName", "VMAEDM"));
        this.m_paSimDbPort.setText(props.getProperty("simulator.simulator.sqlservertcpport", "1433"));
        authItem = convertTwo.getDString(props.getProperty("simulator.simulator.dbtoken", ""));
        this.m_paSimDbUser.setText(authItem != null ? authItem.getName() : "");
        this.m_paSimDbPassword.setText(authItem != null ? authItem.getPassword() : "");
        this.m_publisherTimeout.setText(props.getProperty("simulator.PublisherTimeout", ""));
        this.m_dataTimeOut.setText(props.getProperty("simulator.datatimeout", ""));
        this.m_returnPort.setText(props.getProperty("simulator.service.returnport", ""));
        this.m_localHost.setText(this.m_node.getLocalHost());
        this.taskPropertyChanged(new VWTaskPropertyChangedEvent((Object)this, 2));
    }

    private boolean validateProperties() {
        try {
            this.m_tabbedPane.validateProperties();
            int javaMinMem = Integer.parseInt(this.m_javaMinMem.getText().trim());
            int javaMaxMem = Integer.parseInt(this.m_javaMaxMem.getText().trim());
            if (javaMaxMem < javaMinMem) {
                throw new Exception(filenet.vw.apps.taskman.resources.VWResource.InvalidJavaMemory);
            }
        }
        catch (Exception e) {
            this.m_node.displayError(e);
            return false;
        }
        return true;
    }
}

